/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2024 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "ssd1306.h"	// pozn. Pro displej 1,3" nutno upravit hodnotu - SSD1306_WIDTH: 128 -> 130
#include "fonts.h"
#include "DS18B20.h"
#include "_dDataFLASH.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
  #define 	LED_NAHORU			GPIOA, LL_GPIO_PIN_1    	// LEDky
  #define	LED_DOLU			GPIOA, LL_GPIO_PIN_2

  #define	TL_NAHORU		 	GPIOF, LL_GPIO_PIN_0      	// Tlacitka
  #define	TL_DOLU	 			GPIOF, LL_GPIO_PIN_1
  #define	TL_OK_MENU		 	GPIOA, LL_GPIO_PIN_0


  #define 	TOPENI_1_PRIMOTOP	GPIOA, LL_GPIO_PIN_7    	// Vystupy
  #define 	TOPENI_2_RADIATOR	GPIOA, LL_GPIO_PIN_6

  #define 	T_MISTNOST 			GPIOB, LL_GPIO_PIN_1    	// Vstupy / Vystupy
//---------------------------------------------------------------------------------

  #define	ROZSAH_MENU				1
  #define	ROZSAH_VELICIN			1

  #define	RE_TEPLOTA				2		// 70 = 70 s				// interval po, kterem se opakuje mereni teploty v mistnosti
  #define 	CHYBA_TEPLOT_POCET		200		// Pocet chybnych opakovani mereni pred vyhlasenim chyby cidla teploty
  #define 	HYSTEREZE_TEPLOTA		5		// Hystereze termostatu, 5 -> 0,5 C

  #define 	CAS_DISPLEJ				60		// Cas, po ktery bude aktivni displej po stisku tlacitka [s], pr. 300 -> 300 s (5 min)

  #define 	VERZE_SW				100		// Verze SW, 101 -> 1.1		// mozno az do verze x.50
//---------------------------------------------------------------------------------
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
I2C_HandleTypeDef hi2c1;

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_I2C1_Init(void);
static void MX_IWDG_Init(void);
static void MX_TIM1_Init(void);
static void MX_TIM3_Init(void);
static void MX_TIM16_Init(void);
/* USER CODE BEGIN PFP */
void bubbleSort(uint16_t input[], uint8_t n, uint16_t output[]);

void TIM3_ZAP(void);
void TIM3_VYP(void);
void TIM16_ZAP(void);
void TIM16_VYP(void);

void Zapni_Primotop(void);
void Vypni_Primotop(void);
void Zapni_Radiator(void);
void Vypni_Radiator(void);

void Zobraz_hl_obrazovku(void);
void Zobraz_tecku(void);
void Zobraz_velicinu(void);
void Zobraz_Teplotu(uint16_t aktualni_teplota);
void Uprav_menu(uint8_t pozice);
void Uprav_menu_2(uint8_t pozice);
void Zkontroluj_tlacitka(void);


/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

uint16_t blik_T16 = 0;

uint16_t teplota_mistnost_nefiltr = 0;
uint16_t teplota_mistnost = 0;

uint16_t teplota_radiator_nastavena = 0;
uint16_t teplota_primotop_nastavena = 0;

uint16_t teplota_nastaveni = 0;

uint16_t teplota_mistnost_pole[50];
uint16_t teplota_mistnost_pole_serazene[50];
uint8_t teplota_pole_pozice = 0;

uint8_t chyba_1 = 0;
uint8_t chyba_1_filtr = 0;	// chyba cidla teploty v mistnosti

uint8_t menu_pozice = 0;
uint8_t menu_pozice_2 = 0;
uint8_t menu = 0;
uint16_t displej_casovac = 0;
uint8_t disp_sleep_1 = 0;
uint8_t disp_sleep_2 = 0;

uint32_t hodiny = 0;

uint8_t topeni = 0;	// signalizace aktualniho zdroje tepla, 0 - vypnuto, 1 - primotop, 2 - radiator, 3 - primotop i radiator

uint32_t mC = 0;
char smC[5];
//-------------------------------------------------------------------
void TIM3_ZAP(void)
{
	TIM3->CNT = 0;
    TIM3->SR &= ~TIM_SR_UIF;
    TIM3->DIER |= TIM_DIER_UIE;  // povol interrupt od TIM7
    TIM3->CR1 |= TIM_CR1_CEN;    // spust TIM7
}

void TIM3_VYP(void)
{
	TIM3->DIER &= ~TIM_DIER_UIE;  // zakaz interrupt od TIM7
	TIM3->CR1 &= ~TIM_CR1_CEN;    // zastav TIM7
}
//-------------------------------------------------------------------
void TIM16_ZAP(void)
{
    TIM16->CNT = 0;
    TIM16->SR &= ~TIM_SR_UIF;
    TIM16->DIER |= TIM_DIER_UIE;  // povol interrupt od TIM16
    TIM16->CR1 |= TIM_CR1_CEN;    // spust TIM16
}

void TIM16_VYP(void)
{
	TIM16->DIER &= ~TIM_DIER_UIE;  // zakaz interrupt od TIM16
	TIM16->CR1 &= ~TIM_CR1_CEN;    // zastav TIM16
}
//-------------------------------------------------------------------
void Zapni_Primotop(void)
{
	LL_GPIO_SetOutputPin(TOPENI_1_PRIMOTOP);
}

void Vypni_Primotop(void)
{
	LL_GPIO_ResetOutputPin(TOPENI_1_PRIMOTOP);
}
//-------------------------------------------------------------------
void Zapni_Radiator(void)
{
	LL_GPIO_ResetOutputPin(TOPENI_2_RADIATOR);
}

void Vypni_Radiator(void)
{
	LL_GPIO_SetOutputPin(TOPENI_2_RADIATOR);
}
//-------------------------------------------------------------------

// Funkce pro serazeni pole pomoci bubble sort
void bubbleSort(uint16_t input[], uint8_t n, uint16_t output[])
{
    // Kopiruj vstupni pole do vstupniho pole
    for (uint8_t i = 0; i < n; i++)
    {
        output[i] = input[i];
    }

    // Bubble sort na vstupnim poli
    uint8_t i, j;
    for (i = 0; i < n-1; i++)
    {
        for (j = 0; j < n-i-1; j++)
        {
            if (output[j] > output[j+1])
            {
                // Vmena prvku
            	uint16_t temp = output[j];
                output[j] = output[j+1];
                output[j+1] = temp;
            }
        }
    }
}

void TIM3_IRQHandler(void)	// TIM3 - hlavni smycka 1 s
{
	if(TIM3->SR & TIM_SR_UIF) // if UIF flag is set
	{
		TIM3->SR &= ~TIM_SR_UIF; // clear UIF flag
	}

	hodiny++;

	uint8_t opak_teplota = 0;

	uint32_t* Flash_point;
	uint32_t Do_Flash[3];
	uint32_t Flash_cteni[3];

	//----------------------inkrementace promene pro medianovy filtr teplot
	if (hodiny % RE_TEPLOTA)
	{
		teplota_pole_pozice++;
		if (teplota_pole_pozice >= 50)
			teplota_pole_pozice = 0;
	}
	//---------------------------------Mereni teploty v mistnosti---------------------------------------------
	if((hodiny % RE_TEPLOTA) == 1)
	{
		opak_teplota = 0;
		while (opak_teplota < 4)
		{
			teplota_mistnost_nefiltr = zjisti_teplotu(T_MISTNOST);

			uint8_t u = 0xFF;	// Male zpozdeni
			while(u != 0)
				u--;

			teplota_mistnost_nefiltr = zjisti_teplotu(T_MISTNOST);

			 if ((teplota_mistnost_nefiltr > 1250) && (teplota_mistnost_nefiltr <= 2000))// Teplota je vyssi nez 125 C -> zrejme chyba cidla
				 chyba_1_filtr++;
			 else if (teplota_mistnost_nefiltr > 2550)	// teplota nizsi nez -55 C
				 chyba_1_filtr++;
			 else
			 {
				 chyba_1_filtr = 0;
				 opak_teplota = 4;

				 //-----------medianovy filtr pomoci pole 50 hodnot - vypocet trva pri 24 MHz cca 50 us, zabira cca 0,2 kB v RAM
				 teplota_mistnost_pole[teplota_pole_pozice] = teplota_mistnost_nefiltr;

				 bubbleSort(teplota_mistnost_pole, 50, teplota_mistnost_pole_serazene);
				 //----------------------------------------------------
				 teplota_mistnost = teplota_mistnost_pole_serazene[24];	// median z 50 hodnot
			 }
			 opak_teplota++;

			 LL_IWDG_ReloadCounter(IWDG);	//  Watchdog
		}

		if (chyba_1_filtr > CHYBA_TEPLOT_POCET)
		{
			chyba_1 = 1;
			chyba_1_filtr = CHYBA_TEPLOT_POCET + 1;
		}
		else
		{
			chyba_1 = 0;
		}

	}
	//---------------------------------Casovac na displej------------------------------------------------
	if (displej_casovac > 0)
		displej_casovac--;

	//---------------------------------Ovladani topeni---------------------------------------------------
	// topeni - signalizace aktualniho zdroje tepla, 0 - vypnuto, 1 - primotop, 2 - radiator, 3 - primotop i radiator
	if ((teplota_mistnost > teplota_radiator_nastavena) && (topeni != 0))
	{
		Vypni_Radiator();
		Vypni_Primotop();

		topeni = 0; // 0 - vypnuto
	}
	else if (((teplota_mistnost < (teplota_radiator_nastavena - HYSTEREZE_TEPLOTA)) && (topeni == 0)) || ((teplota_mistnost > teplota_primotop_nastavena) && (topeni == 3)))
	{
		Zapni_Radiator();
		Vypni_Primotop();

		topeni = 2; // 2 - radiator
	}
	else if ((teplota_mistnost < (teplota_primotop_nastavena - HYSTEREZE_TEPLOTA)) && (topeni != 3))
	{
		Zapni_Radiator();
		Zapni_Primotop();

		topeni = 3; // 3 - primotop i radiator
	}
	else
	{
		;
	}
	//---------------------------------Kontrola ulozeneho nastaveni-----------------
	if ((hodiny % 720) == 1)	// kazdych 12 min. zkontroluj jestli se shoduji hodnoty v RAM a FLASH. 12 min. kvuli rozlozeni operaci.
	{
		  Flash_point = CteniFlash_3();		// Nacteni ulozenych hodnot z FLASH

		  Flash_cteni[0] = *Flash_point;
		  Flash_cteni[1] = *(Flash_point + 1);
		  Flash_cteni[2] = *(Flash_point + 2);


		  uint16_t teplota_primotop_nastavena_kontr 	= 	(uint16_t) (Flash_cteni[0] & 0x00000FFF);
		  uint16_t teplota_radiator_nastavena_kontr 	= 	(uint16_t)((Flash_cteni[0] & 0x00FFF000) >> 12);



		  uint8_t flash_zapis_ANO = 0;

		  if (teplota_primotop_nastavena_kontr != teplota_primotop_nastavena)
		  {
			  teplota_primotop_nastavena_kontr = teplota_primotop_nastavena;
			  flash_zapis_ANO = 1;
		  }
		  if (teplota_radiator_nastavena_kontr != teplota_radiator_nastavena)
		  {
			  teplota_radiator_nastavena_kontr = teplota_radiator_nastavena;
			  flash_zapis_ANO = 1;
		  }
		  //----------------
		  if (flash_zapis_ANO == 1)	// Byla-li zjistena jakakoli neshoda dat
		  {
			    Do_Flash[0] = (teplota_primotop_nastavena_kontr + (teplota_radiator_nastavena_kontr << 12));
			    Do_Flash[1] = 0;
			    Do_Flash[2] = 0;

			  ZapisFlash_3(Do_Flash);
		  }


	}
	//------------------------------------------------------------------------------


	LL_IWDG_ReloadCounter(IWDG);	//  Watchdog

	if(menu == 0)
	{
		Zobraz_hl_obrazovku();
	}
}

void TIM16_IRQHandler(void)	// TIM16 - casovac pro tlacitka 10 ms
{
	if(TIM16->SR & TIM_SR_UIF) // if UIF flag is set
	{
		TIM16->SR &= ~TIM_SR_UIF; // clear UIF flag

		blik_T16++;
	}
}



void Zobraz_hl_obrazovku(void)
{
	if (displej_casovac > 0)
	{
		Zobraz_velicinu();
		SSD1306_UpdateScreen();
	}
	else
	{
		Zobraz_tecku();	// usporny rezim OLED displeje
	}

}
//-------------------------------------------------------------------
void Zobraz_tecku(void)
{
	if((hodiny % 32) == 1)	// kazdych 32 s
	{

		SSD1306_Init(); 	// initialize the display
		SSD1306_Clear();	// vymaz displej a prepis ho putujici teckou

		SSD1306_GotoXY (10 + disp_sleep_1, disp_sleep_2);
		SSD1306_Puts (".", &Font_11x18, 1);
		SSD1306_UpdateScreen();

		disp_sleep_1++;

		if(disp_sleep_1 > 90)
		{
			disp_sleep_1 = 0;

			disp_sleep_2 += 5;

			if(disp_sleep_2 > 40)
				disp_sleep_2 = 10;
		}

	}

}
//-------------------------------------------------------------------
void Zobraz_velicinu(void)
{
	/*SSD1306_GotoXY (10, 8); // goto 10, 8
	SSD1306_Puts ("t mistnost", &Font_11x18, 1);*/



	mC = teplota_mistnost  / 10;
	itoa(mC, smC, 10); // Convert integer to string

	//SSD1306_GotoXY (10, 26); // goto 10, 44
	SSD1306_GotoXY (10, 8); // goto 10, 8
	SSD1306_Puts (smC, &Font_11x18, 1);

	mC = teplota_mistnost % 10;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts (",", &Font_11x18, 1);
	SSD1306_Puts (smC, &Font_11x18, 1);
	SSD1306_Puts (" *C   ", &Font_11x18, 1);

	//--------------- signalizace chodu

	if (hodiny % 2)
	{
		SSD1306_GotoXY (110, 2); // goto 110, 2
		SSD1306_Puts (".", &Font_11x18, 1);
	}
	else
	{
		SSD1306_GotoXY (110, 8); // goto 110, 8
		SSD1306_Puts (" ", &Font_11x18, 1);
	}

	//--------------- signalizace zdroje tepla

	SSD1306_GotoXY (10, 26); // goto 10, 26
	SSD1306_Puts ("radiator  ", &Font_11x18, 1);
	SSD1306_GotoXY (10, 44); // goto 10, 44
	SSD1306_Puts ("primotop  ", &Font_11x18, 1);

	// topeni - signalizace aktualniho zdroje tepla, 0 - vypnuto, 1 - primotop, 2 - radiator, 3 - primotop i radiator
	if (topeni == 0)	// 0 - vypnuto
	{
		SSD1306_GotoXY (110, 26); // goto 10, 26
		SSD1306_Puts (" ", &Font_11x18, 1);
		SSD1306_GotoXY (110, 44); // goto 10, 44
		SSD1306_Puts (" ", &Font_11x18, 1);
	}
	else if (topeni == 1)	// 1 - primotop
	{

		SSD1306_GotoXY (110, 26); // goto 10, 26
		SSD1306_Puts (" ", &Font_11x18, 1);
		SSD1306_GotoXY (110, 44); // goto 10, 44
		SSD1306_Puts ("<", &Font_11x18, 1);

	}
	else if (topeni == 2)	// 2 - radiator
	{
		SSD1306_GotoXY (110, 26); // goto 10, 26
		SSD1306_Puts ("<", &Font_11x18, 1);
		SSD1306_GotoXY (110, 44); // goto 10, 44
		SSD1306_Puts (" ", &Font_11x18, 1);

	}
	else	// 3 - primotop i radiator
	{
		SSD1306_GotoXY (110, 26); // goto 10, 26
		SSD1306_Puts ("<", &Font_11x18, 1);
		SSD1306_GotoXY (110, 44); // goto 10, 44
		SSD1306_Puts ("<", &Font_11x18, 1);

	}


}
//-------------------------------------------------------------------
void Zobraz_Teplotu(uint16_t aktualni_teplota)
{
	mC = aktualni_teplota  / 10;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_GotoXY (10, 8); // goto 10, 8
	SSD1306_Puts (smC, &Font_11x18, 1);

	mC = aktualni_teplota % 10;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts (",", &Font_11x18, 1);
	SSD1306_Puts (smC, &Font_11x18, 1);
	SSD1306_Puts (" *C   ", &Font_11x18, 1);


	//if (menic_v_chodu != 1)
		SSD1306_UpdateScreen(); // update screen
}
//-------------------------------------------------------------------
void Uprav_menu(uint8_t pozice)
{
	if(pozice == 0)
	{
		 SSD1306_GotoXY(10, 8); // goto 10, 8
		 SSD1306_Puts ("t primotop", &Font_11x18, 0);	// na font 11x18 max. 10 pismen
		 SSD1306_GotoXY(10, 26); // goto 10, 26
		 SSD1306_Puts ("t radiator", &Font_11x18, 1);
	}
	else if (pozice == 1)
	{
		 SSD1306_GotoXY(10, 8); // goto 10, 8
		 SSD1306_Puts ("t primotop", &Font_11x18, 1);	// na font 11x18 max. 10 pismen
		 SSD1306_GotoXY(10, 26); // goto 10, 26
		 SSD1306_Puts ("t radiator", &Font_11x18, 0);
	}
	else
	{
		 SSD1306_GotoXY(10, 8); // goto 10, 8
		 SSD1306_Puts ("t primotop", &Font_11x18, 0);	// na font 11x18 max. 10 pismen
		 SSD1306_GotoXY(10, 26); // goto 10, 26
		 SSD1306_Puts ("t radiator", &Font_11x18, 1);
	}

	//if (menic_v_chodu != 1)
		SSD1306_UpdateScreen(); // update screen
}
//-------------------------------------------------------------------
void Uprav_menu_2(uint8_t pozice)
{
	if(pozice == 0)
	{
		Zobraz_Teplotu(teplota_primotop_nastavena);		// Solar zap.
	}
	else if (pozice == 1)
	{
		Zobraz_Teplotu(teplota_radiator_nastavena);		// Solar vyp.
	}
	else
	{
		 ;
	}

	//if (menic_v_chodu != 1)
		SSD1306_UpdateScreen(); // update screen
}
//-------------------------------------------------------------------
void Zkontroluj_tlacitka(void)
{
	 if (!LL_GPIO_IsInputPinSet(TL_NAHORU))	// TL_NAHORU
	 {
		 blik_T16 = 0;
		 TIM16_ZAP();
		 while(blik_T16 < 2);	// 20 ms
		 TIM16_VYP();

		 if (!LL_GPIO_IsInputPinSet(TL_NAHORU))
		 {
			 blik_T16 = 0;
			 TIM16_ZAP();
			 while(blik_T16 < 5);	// 50 ms
			 TIM16_VYP();

			 if (!LL_GPIO_IsInputPinSet(TL_NAHORU))
			 {

				 blik_T16 = 0;
				 TIM16_ZAP();
				 while((!LL_GPIO_IsInputPinSet(TL_NAHORU)) && (blik_T16 <= 250));
				 TIM16_VYP();

				 //--------------------------
				 if(blik_T16 > 250)	// dlouhy stisk tlacitka TL_NAHORU
				 {
					 if (menu_pozice_2 == 1)	// druha uroven menu
					 {
						if(menu_pozice == 0)
						{
							blik_T16 = 0;
							TIM16_ZAP();
							while(!LL_GPIO_IsInputPinSet(TL_NAHORU))
							{
								teplota_primotop_nastavena += 1;
								if(teplota_primotop_nastavena > 260)
								{
									teplota_primotop_nastavena = 260;
								}

								if(teplota_primotop_nastavena >= (teplota_radiator_nastavena - 10))
								{
									teplota_primotop_nastavena = (teplota_radiator_nastavena - 10);
								}
								Uprav_menu_2(menu_pozice);
							}
							TIM16_VYP();
						}
						else if (menu_pozice == 1)
						{
							blik_T16 = 0;
							TIM16_ZAP();
							while(!LL_GPIO_IsInputPinSet(TL_NAHORU))
							{
								teplota_radiator_nastavena += 1;
								if(teplota_radiator_nastavena > 260)
								{
									teplota_radiator_nastavena = 260;
								}
								Uprav_menu_2(menu_pozice);
							}
							TIM16_VYP();
						}
						else
						{
							;
						}

					 }
				 }
				 else				// kratky stisk tlacitka TL_NAHORU
				 {

					 if(menu == 1)	// Pouze, jsem-li v menu
					 {
						 if (menu_pozice_2 == 0)	// prvni uroven menu
						 {
							 if (menu_pozice == 0)
								 menu_pozice = 0;
							 else
								menu_pozice--;

							 Uprav_menu(menu_pozice);
						 }
						 else	// druha uroven menu
						 {
							if(menu_pozice == 0)
							{
								teplota_primotop_nastavena += 1;
								if(teplota_primotop_nastavena > 260)
								{
									teplota_primotop_nastavena = 260;
								}

								if(teplota_primotop_nastavena >= (teplota_radiator_nastavena - 10))
								{
									teplota_primotop_nastavena = (teplota_radiator_nastavena - 10);
								}
							}
							else if (menu_pozice == 1)
							{
								teplota_radiator_nastavena += 1;
								if(teplota_radiator_nastavena > 260)
								{
									teplota_radiator_nastavena = 260;
								}
							}
							else
							{
								;
							}

							Uprav_menu_2(menu_pozice);
						 }
					 }
					 else // Zmena zobrazovane veliciny na hlavni obrazovce
					 {
						;
					 }

					 displej_casovac = CAS_DISPLEJ;
				 }


				 while(!LL_GPIO_IsInputPinSet(TL_NAHORU));

				 blik_T16 = 0;
				 TIM16_ZAP();
				 while(blik_T16 < 4);	// 40 ms
				 TIM16_VYP();
			 }
		 }
	 }
	 //**********************************************************
	 if (!LL_GPIO_IsInputPinSet(TL_DOLU))	// TL_DOLU
	 {
		 blik_T16 = 0;
		 TIM16_ZAP();
		 while(blik_T16 < 2);	// 20 ms
		 TIM16_VYP();

		 if (!LL_GPIO_IsInputPinSet(TL_DOLU))
		 {
			 blik_T16 = 0;
			 TIM16_ZAP();
			 while(blik_T16 < 5);	// 50 ms
			 TIM16_VYP();

			 if (!LL_GPIO_IsInputPinSet(TL_DOLU))
			 {
				 blik_T16 = 0;
				 TIM16_ZAP();
				 while((!LL_GPIO_IsInputPinSet(TL_DOLU)) && (blik_T16 <= 250));
				 TIM16_VYP();

				 //--------------------------
				 if(blik_T16 > 250)	// dlouhy stisk tlacitka TL_DOLU
				 {
					 if (menu_pozice_2 == 1)	// druha uroven menu
					 {
						if(menu_pozice == 0)
						{
							blik_T16 = 0;
							TIM16_ZAP();
							while(!LL_GPIO_IsInputPinSet(TL_DOLU))
							{
								teplota_primotop_nastavena -= 1;
								if(teplota_primotop_nastavena < 190)
								{
									teplota_primotop_nastavena = 190;
								}
								Uprav_menu_2(menu_pozice);
							}
							TIM16_VYP();
						}
						else if (menu_pozice == 1)
						{
							blik_T16 = 0;
							TIM16_ZAP();
							while(!LL_GPIO_IsInputPinSet(TL_DOLU))
							{
								teplota_radiator_nastavena -= 1;
								if(teplota_radiator_nastavena < 190)
								{
									teplota_radiator_nastavena = 190;
								}

								if(teplota_radiator_nastavena <= (teplota_primotop_nastavena + 10))
								{
									teplota_radiator_nastavena = (teplota_primotop_nastavena + 10);
								}
								Uprav_menu_2(menu_pozice);
							}
							TIM16_VYP();
						}
						else
						{
							;
						}

					 }
				 }
				 else	// kratky stisk tlacitka TL_DOLU
				 {
					 if(menu == 1)	// Pouze, jsem-li v menu
					 {
						 if (menu_pozice_2 == 0)	// prvni uroven menu
						 {
							 menu_pozice++;

							 if(menu_pozice >= ROZSAH_MENU)
								 menu_pozice = ROZSAH_MENU;

							 Uprav_menu(menu_pozice);
						 }
						 else	// druha uroven menu
						 {
							if(menu_pozice == 0)
							{
								teplota_primotop_nastavena -= 1;
								if(teplota_primotop_nastavena < 190)
								{
									teplota_primotop_nastavena = 190;
								}

							}
							else if (menu_pozice == 1)
							{
								teplota_radiator_nastavena -= 1;
								if(teplota_radiator_nastavena < 190)
								{
									teplota_radiator_nastavena = 190;
								}

								if(teplota_radiator_nastavena <= (teplota_primotop_nastavena + 10))
								{
									teplota_radiator_nastavena = (teplota_primotop_nastavena + 10);
								}
							}
							else
							{
								;
							}

							Uprav_menu_2(menu_pozice);
						 }
					 }
					 else // Zmena zobrazovane veliciny na hlavni obrazovce
					 {
						 ;
					 }

					 displej_casovac = CAS_DISPLEJ;
				 }

				 while(!LL_GPIO_IsInputPinSet(TL_DOLU));

				 blik_T16 = 0;
				 TIM16_ZAP();
				 while(blik_T16 < 4);	// 40 ms
				 TIM16_VYP();
			 }
		 }
	 }
	 //**********************************************************
	 if (!LL_GPIO_IsInputPinSet(TL_OK_MENU))	// TL_OK_MENU
	 {
		 blik_T16 = 0;
		 TIM16_ZAP();
		 while(blik_T16 < 2);	// 20 ms
		 TIM16_VYP();

		 if (!LL_GPIO_IsInputPinSet(TL_OK_MENU))
		 {
			 blik_T16 = 0;
			 TIM16_ZAP();
			 while(blik_T16 < 5);	// 50 ms
			 TIM16_VYP();

			 if (!LL_GPIO_IsInputPinSet(TL_OK_MENU))
			 {

				 blik_T16 = 0;
				 TIM16_ZAP();
				 while((!LL_GPIO_IsInputPinSet(TL_OK_MENU)) && (blik_T16 <= 250));
				 TIM16_VYP();

				 //--------------------------
				 if(blik_T16 > 250)	// dlouhy stisk tlacitka TL_OK_MENU
				 {
					 SSD1306_Fill(SSD1306_COLOR_BLACK);	// Vymaz displej

					 if (menu == 0)
					 {
						 menu = 1;
						 menu_pozice = 0;
						 menu_pozice_2 = 0;

						 SSD1306_GotoXY(10, 8); // goto 10, 8
						 SSD1306_Puts ("t primotop", &Font_11x18, 0);	// na font 11x18 max. 10 pismen
						 SSD1306_GotoXY(10, 26); // goto 10, 26
						 SSD1306_Puts ("t radiator", &Font_11x18, 1);

						 SSD1306_UpdateScreen(); // update screen
					 }
					 else
					 {
						 menu = 0;
						 Zobraz_velicinu();
						 //Zobraz_hl_obrazovku();
						 SSD1306_UpdateScreen(); // update screen
					 }
				 }
				 else	// kratky stisk tlacitka TL_OK_MENU
				 {
					 if (menu == 1)
					 {
						 if(menu_pozice_2 == 0)
						 {
								menu_pozice_2 = 1;	// druha uroven menu

								if(menu_pozice == 0)		// Solar zap.
								{
									SSD1306_Fill(SSD1306_COLOR_BLACK);	// Vymaz displej

									teplota_nastaveni = teplota_primotop_nastavena;
									Zobraz_Teplotu(teplota_nastaveni);
								}
								else if (menu_pozice == 1)	// Solar vyp.
								{
									SSD1306_Fill(SSD1306_COLOR_BLACK);	// Vymaz displej

									teplota_nastaveni = teplota_radiator_nastavena;
									Zobraz_Teplotu(teplota_nastaveni);
								}
								else
								{
									 SSD1306_GotoXY(10, 8); // goto 10, 8
									 SSD1306_Puts ("t primotop", &Font_11x18, 0);	// na font 11x18 max. 10 pismen
									 SSD1306_GotoXY(10, 26); // goto 10, 26
									 SSD1306_Puts ("t radiator", &Font_11x18, 1);
								}

						 }
						 else
						 {
							 menu_pozice_2 = 0;	// zpet do prvni urovne menu

							 /*if(menu_pozice == 0)
							 {
								hodiny = hodiny_nastaveni;
							 }*/

							 menu_pozice = 0;

							 SSD1306_Fill(SSD1306_COLOR_BLACK);	// Vymaz displej

							 SSD1306_GotoXY(10, 8); // goto 10, 8
							 SSD1306_Puts ("t primotop", &Font_11x18, 0);	// na font 11x18 max. 10 pismen
							 SSD1306_GotoXY(10, 26); // goto 10, 26
							 SSD1306_Puts ("t radiator", &Font_11x18, 1);
						 }

						 //if (menic_v_chodu != 1)
							 SSD1306_UpdateScreen(); // update screen

					 }

					 displej_casovac = CAS_DISPLEJ;
				 }

				 while(!LL_GPIO_IsInputPinSet(TL_OK_MENU));

				 blik_T16 = 0;
				 TIM16_ZAP();
				 while(blik_T16 < 4);	// 40 ms
				 TIM16_VYP();
			 }
		 }
	 }
}
//-------------------------------------------------------------------
/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

	uint32_t* Flash_point;
	uint32_t Do_Flash[3];
	uint32_t Flash_cteni[3];

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_I2C1_Init();
  MX_IWDG_Init();
  MX_TIM1_Init();
  MX_TIM3_Init();
  MX_TIM16_Init();
  /* USER CODE BEGIN 2 */
  SSD1306_Init(); // initialize the display

  //---------------------------------------------------	uvodni inicializace
  teplota_primotop_nastavena = 215;		// 215 -> 21,5 C
  teplota_radiator_nastavena = 235;		// 235 -> 23,5 C

  uint8_t start_pole = 0;
  while (start_pole < 49)	// startovni naplneni pole teplot v mistnosti - aby se nezapnul primoto nez se pole naplni realnymi daty
  {
	  teplota_mistnost_pole[start_pole] = 270;
	  start_pole++;
  }
  //---------------------------------------------------

  displej_casovac = CAS_DISPLEJ;
  topeni = 0;

  //--------------------------------------- Inicializace Flash
  Flash_point = CteniFlash_3();

  if(Flash_point == 0)
  {
    Do_Flash[0] = (teplota_primotop_nastavena) + (teplota_radiator_nastavena << 12);
    Do_Flash[1] = 0;
    Do_Flash[2] = 0;

    ZapisFlash_3(Do_Flash);
  }
  //---------------------------------------

  Flash_point = CteniFlash_3();		// Nacteni ulozenych hodnot z FLASH

  Flash_cteni[0] = *Flash_point;
  Flash_cteni[1] = *(Flash_point + 1);
  Flash_cteni[2] = *(Flash_point + 2);


  teplota_primotop_nastavena 	= 	(uint16_t) (Flash_cteni[0] & 0x00000FFF);
  teplota_radiator_nastavena 	= 	(uint16_t)((Flash_cteni[0] & 0x00FFF000) >> 12);

  //---------------------------------------------------
  SSD1306_GotoXY(10, 8); // goto 10, 8
  SSD1306_Puts("Pokojovy  ", &Font_11x18, 1);// na font 11x18 max. 10 pismen
  SSD1306_GotoXY (10, 26); // goto 10, 26
  SSD1306_Puts ("termostat ", &Font_11x18, 1);
  SSD1306_GotoXY(10, 44); // goto 10, 44
  SSD1306_Puts ("v ", &Font_11x18, 1);

	mC = VERZE_SW / 100;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts (smC, &Font_11x18, 1);
	SSD1306_Puts (".", &Font_11x18, 1);

	mC = VERZE_SW % 50;
	itoa(mC, smC, 10); // Convert integer to string
	SSD1306_Puts (smC, &Font_11x18, 1);
	SSD1306_UpdateScreen(); // update screen



	blik_T16 = 0;
	TIM16_ZAP();
	while(blik_T16 < 400)	// 4 s - Start programu, aby byla videt uvodni obrazovka
	{
		LL_IWDG_ReloadCounter(IWDG);	//  Watchdog
	}
	TIM16_VYP();

	TIM3_ZAP();

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */
	  Zkontroluj_tlacitka();






/*
	  teplota_mistnost_nefiltr = zjisti_teplotu(T_MISTNOST);


	  if(teplota_mistnost_nefiltr < 1251)	// maximalni kladna teplota 125 C
		{
			mC = teplota_mistnost_nefiltr / 10;
			itoa(mC, smC, 10); // Convert integer to string

			SSD1306_GotoXY(10, 8); // goto 10, 8
			SSD1306_Puts("t ", &Font_11x18, 1);
			SSD1306_Puts(smC, &Font_11x18, 1);

			  mC = teplota_mistnost_nefiltr % 10;
			  itoa(mC, smC, 10); // Convert integer to string

			  SSD1306_Puts (",", &Font_11x18, 1);
			  SSD1306_Puts (smC, &Font_11x18, 1);
			  SSD1306_Puts (" *C", &Font_11x18, 1);
			SSD1306_UpdateScreen(); // update screen
		}
		else		// Zaporna teplota
		{
			mC = teplota_mistnost_nefiltr - 2000;	// Odecti offset
			mC = mC / 10;
			itoa(mC, smC, 10); // Convert integer to string

			SSD1306_GotoXY(10, 8); // goto 10, 8
			SSD1306_Puts("t -", &Font_11x18, 1);
			SSD1306_Puts(smC, &Font_11x18, 1);
			SSD1306_Puts(" *C  ", &Font_11x18, 1);
			SSD1306_UpdateScreen(); // update screen
		}*/


    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  LL_FLASH_SetLatency(LL_FLASH_LATENCY_0);
  while(LL_FLASH_GetLatency() != LL_FLASH_LATENCY_0)
  {
  }
  LL_RCC_HSI_Enable();

   /* Wait till HSI is ready */
  while(LL_RCC_HSI_IsReady() != 1)
  {

  }
  LL_RCC_HSI_SetCalibTrimming(16);
  LL_RCC_LSI_Enable();

   /* Wait till LSI is ready */
  while(LL_RCC_LSI_IsReady() != 1)
  {

  }
  LL_RCC_PLL_ConfigDomain_SYS(LL_RCC_PLLSOURCE_HSI, LL_RCC_PLL_MUL_3, LL_RCC_PREDIV_DIV_1);
  LL_RCC_PLL_Enable();

   /* Wait till PLL is ready */
  while(LL_RCC_PLL_IsReady() != 1)
  {

  }
  LL_RCC_SetAHBPrescaler(LL_RCC_SYSCLK_DIV_1);
  LL_RCC_SetAPB1Prescaler(LL_RCC_APB1_DIV_1);
  LL_RCC_SetSysClkSource(LL_RCC_SYS_CLKSOURCE_PLL);

   /* Wait till System clock is ready */
  while(LL_RCC_GetSysClkSource() != LL_RCC_SYS_CLKSOURCE_STATUS_PLL)
  {

  }
  LL_SetSystemCoreClock(24000000);

   /* Update the time base */
  if (HAL_InitTick (TICK_INT_PRIORITY) != HAL_OK)
  {
    Error_Handler();
  }
  LL_RCC_SetI2CClockSource(LL_RCC_I2C1_CLKSOURCE_HSI);
}

/**
  * @brief I2C1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C1_Init(void)
{

  /* USER CODE BEGIN I2C1_Init 0 */

  /* USER CODE END I2C1_Init 0 */

  /* USER CODE BEGIN I2C1_Init 1 */

  /* USER CODE END I2C1_Init 1 */
  hi2c1.Instance = I2C1;
  hi2c1.Init.Timing = 0x00000A17; //0x00000A17; - 200 kHz, 0x2000090E - 100 kHz
  hi2c1.Init.OwnAddress1 = 0;
  hi2c1.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
  hi2c1.Init.DualAddressMode = I2C_DUALADDRESS_DISABLE;
  hi2c1.Init.OwnAddress2 = 0;
  hi2c1.Init.OwnAddress2Masks = I2C_OA2_NOMASK;
  hi2c1.Init.GeneralCallMode = I2C_GENERALCALL_DISABLE;
  hi2c1.Init.NoStretchMode = I2C_NOSTRETCH_DISABLE;
  if (HAL_I2C_Init(&hi2c1) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure Analogue filter
  */
  if (HAL_I2CEx_ConfigAnalogFilter(&hi2c1, I2C_ANALOGFILTER_ENABLE) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure Digital filter
  */
  if (HAL_I2CEx_ConfigDigitalFilter(&hi2c1, 0) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN I2C1_Init 2 */

  /* USER CODE END I2C1_Init 2 */

}

/**
  * @brief IWDG Initialization Function
  * @param None
  * @retval None
  */
static void MX_IWDG_Init(void)
{

  /* USER CODE BEGIN IWDG_Init 0 */

  /* USER CODE END IWDG_Init 0 */

  /* USER CODE BEGIN IWDG_Init 1 */

  /* USER CODE END IWDG_Init 1 */
  LL_IWDG_Enable(IWDG);
  LL_IWDG_EnableWriteAccess(IWDG);
  LL_IWDG_SetPrescaler(IWDG, LL_IWDG_PRESCALER_32);	// 3,3 s
  LL_IWDG_SetReloadCounter(IWDG, 4095);
  while (LL_IWDG_IsReady(IWDG) != 1)
  {
  }

  LL_IWDG_ReloadCounter(IWDG);
  /* USER CODE BEGIN IWDG_Init 2 */

  /* USER CODE END IWDG_Init 2 */

}

/**
  * @brief TIM1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM1_Init(void)
{

  /* USER CODE BEGIN TIM1_Init 0 */

  /* USER CODE END TIM1_Init 0 */

  LL_TIM_InitTypeDef TIM_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_TIM1);

  /* TIM1 interrupt Init */
  NVIC_SetPriority(TIM1_BRK_UP_TRG_COM_IRQn, 0);
  NVIC_EnableIRQ(TIM1_BRK_UP_TRG_COM_IRQn);

  /* USER CODE BEGIN TIM1_Init 1 */

  /* USER CODE END TIM1_Init 1 */
  TIM_InitStruct.Prescaler = 0;
  TIM_InitStruct.CounterMode = LL_TIM_COUNTERMODE_UP;
  TIM_InitStruct.Autoreload = 65535;
  TIM_InitStruct.ClockDivision = LL_TIM_CLOCKDIVISION_DIV1;
  TIM_InitStruct.RepetitionCounter = 0;
  LL_TIM_Init(TIM1, &TIM_InitStruct);
  LL_TIM_DisableARRPreload(TIM1);
  LL_TIM_SetClockSource(TIM1, LL_TIM_CLOCKSOURCE_INTERNAL);
  LL_TIM_SetTriggerOutput(TIM1, LL_TIM_TRGO_RESET);
  LL_TIM_DisableMasterSlaveMode(TIM1);
  /* USER CODE BEGIN TIM1_Init 2 */

  /* USER CODE END TIM1_Init 2 */

}

/**
  * @brief TIM3 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM3_Init(void)	//* Hlavni smycka - 1 s
{

  /* USER CODE BEGIN TIM3_Init 0 */

  /* USER CODE END TIM3_Init 0 */

  LL_TIM_InitTypeDef TIM_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_TIM3);

  /* TIM3 interrupt Init */
  NVIC_SetPriority(TIM3_IRQn, 0);
  NVIC_EnableIRQ(TIM3_IRQn);

  /* USER CODE BEGIN TIM3_Init 1 */

  /* USER CODE END TIM3_Init 1 */
  TIM_InitStruct.Prescaler = SystemCoreClock / 1000 - 1; // 1ms = 1kHz
  TIM_InitStruct.CounterMode = LL_TIM_COUNTERMODE_UP;
  TIM_InitStruct.Autoreload = 1000 - 1;	// 1 s
  TIM_InitStruct.ClockDivision = LL_TIM_CLOCKDIVISION_DIV1;
  LL_TIM_Init(TIM3, &TIM_InitStruct);
  LL_TIM_DisableARRPreload(TIM3);
  LL_TIM_SetClockSource(TIM3, LL_TIM_CLOCKSOURCE_INTERNAL);
  LL_TIM_SetTriggerOutput(TIM3, LL_TIM_TRGO_RESET);
  LL_TIM_DisableMasterSlaveMode(TIM3);
  /* USER CODE BEGIN TIM3_Init 2 */

  /* USER CODE END TIM3_Init 2 */

}

/**
  * @brief TIM16 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM16_Init(void)	// Po 10 ms	- casovac pro tlacitka
{

  /* USER CODE BEGIN TIM16_Init 0 */

  /* USER CODE END TIM16_Init 0 */

  LL_TIM_InitTypeDef TIM_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_TIM16);

  /* TIM16 interrupt Init */
  NVIC_SetPriority(TIM16_IRQn, 0);
  NVIC_EnableIRQ(TIM16_IRQn);

  /* USER CODE BEGIN TIM16_Init 1 */

  /* USER CODE END TIM16_Init 1 */
  TIM_InitStruct.Prescaler = SystemCoreClock / 1000 - 1; // 1ms = 1kHz
  TIM_InitStruct.CounterMode = LL_TIM_COUNTERMODE_UP;
  TIM_InitStruct.Autoreload = 10 - 1;	// 10 ms
  TIM_InitStruct.ClockDivision = LL_TIM_CLOCKDIVISION_DIV1;
  TIM_InitStruct.RepetitionCounter = 0;
  LL_TIM_Init(TIM16, &TIM_InitStruct);
  LL_TIM_DisableARRPreload(TIM16);
  /* USER CODE BEGIN TIM16_Init 2 */

  /* USER CODE END TIM16_Init 2 */

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOF);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOB);

  /**/
  LL_GPIO_ResetOutputPin(GPIOA, LL_GPIO_PIN_1);

  /**/
  LL_GPIO_ResetOutputPin(GPIOA, LL_GPIO_PIN_2);

  /**/
  LL_GPIO_ResetOutputPin(GPIOA, LL_GPIO_PIN_6);

  /**/
  LL_GPIO_ResetOutputPin(GPIOA, LL_GPIO_PIN_7);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_0;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOF, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_1;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOF, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_0;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_1;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_2;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_3;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_6;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_7;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_1;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOB, &GPIO_InitStruct);

}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
