// Knihovna pro DS18B20





#include "DS18B20.h"

void delay1 (unsigned int zpozdeni)
{
	unsigned int i = 0;
	//unsigned int y = 0;
	uint32_t zpozdeni2 = (zpozdeni * 20) / 9;

	while(i < zpozdeni2)	// Zpozdeni pro 24 MHz
	{
		i++;
	}
}

int DS18B20_init (GPIO_TypeDef  *GPIOx, uint32_t Pin)
{
	uint8_t Pin_cislo = 0;

	if (Pin == LL_GPIO_PIN_0)
		Pin_cislo = 0;
	else if (Pin == LL_GPIO_PIN_1)
		Pin_cislo = 1;
	else if (Pin == LL_GPIO_PIN_2)
		Pin_cislo = 2;
	else if (Pin == LL_GPIO_PIN_3)
		Pin_cislo = 3;
	else if (Pin == LL_GPIO_PIN_4)
		Pin_cislo = 4;
	else if (Pin == LL_GPIO_PIN_5)
		Pin_cislo = 5;
	else if (Pin == LL_GPIO_PIN_6)
		Pin_cislo = 6;
	else if (Pin == LL_GPIO_PIN_7)
		Pin_cislo = 7;
	else if (Pin == LL_GPIO_PIN_8)
		Pin_cislo = 8;
	else if (Pin == LL_GPIO_PIN_9)
		Pin_cislo = 9;
	else if (Pin == LL_GPIO_PIN_10)
		Pin_cislo = 10;
	else
		Pin_cislo = 15;

	DS18B20_output(GPIOx, Pin_cislo);
	/*HAL_GPIO_WritePin(GPIOx, Pin, GPIO_PIN_SET); // cidlo = 1;*/
	delay1(8);	// slight delay

	//HAL_GPIO_WritePin(GPIOx, Pin, GPIO_PIN_RESET); // cidlo = 0;
	LL_GPIO_ResetOutputPin(GPIOx, Pin);// cidlo = 0;
	delay1(480);
	//DWT_Delay_us (480);   // delay according to datasheet

	DS18B20_input(GPIOx, Pin_cislo); // cidlo = 1;
	delay1(80);
	//DWT_Delay_us (80);    // delay according to datasheet

	if (LL_GPIO_IsInputPinSet(GPIOx, Pin))    // if the pin is low i.e the presence pulse is there
	{
		//DWT_Delay_us (400); // wait for 400 us
		delay1(400);
		return 0;
	}
	else
	{
		//DWT_Delay_us (400);  // wait for 400 us
		delay1(400);
		return 1;
	}
}

void DS18B20_output(GPIO_TypeDef  *GPIOx, uint32_t Pin)
{
	  /*GPIO_InitTypeDef GPIO_InitStruct = {0};

	  __HAL_RCC_GPIOA_CLK_ENABLE();

	  GPIO_InitStruct.Pin = Pin;
	  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
	  GPIO_InitStruct.Pull = GPIO_NOPULL;
	  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
	  HAL_GPIO_Init(GPIOx, &GPIO_InitStruct);*/

	//RCC->AHB1ENR |= (1<<0);  // Enable the GPIOA clock

/*
	 LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

	  GPIO_InitStruct.Pin = Pin;
	  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
	  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_HIGH;
	  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
	  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
	  LL_GPIO_Init(GPIOx, &GPIO_InitStruct);*/

	GPIOx->MODER |= (1<<(Pin*2));  // pin PA5(bits 11:10) as Output (01)

	// 3. Configure the output mode
	GPIOx->OTYPER &= ~(1<<Pin);  // bit 5=0 --> Output push pull
	GPIOx->OSPEEDR |= (1<<((Pin*2)+1));  // Pin PA5 (bits 11:10) as Fast Speed (1:0)
	GPIOx->PUPDR &= ~((1<<(Pin*2)) | (1<<((Pin*2)+1)));  // Pin PA5 (bits 11:10) are 0:0 --> no pull up or pulldown
}

void DS18B20_input(GPIO_TypeDef  *GPIOx, uint32_t Pin)
{
	 /* GPIO_InitTypeDef GPIO_InitStruct = {0};

	 __HAL_RCC_GPIOA_CLK_ENABLE();

	  GPIO_InitStruct.Pin = Pin;
	  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
	  GPIO_InitStruct.Pull = GPIO_NOPULL;
	  HAL_GPIO_Init(GPIOx, &GPIO_InitStruct);*/

	/*LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

	  GPIO_InitStruct.Pin = Pin;
	  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
	  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
	  LL_GPIO_Init(GPIOx, &GPIO_InitStruct);
	*/

	GPIOx->MODER &= ~(1<<(Pin*2));  // pin PA6(bits 11:10) as Output (01)

	// 3. Configure the output mode
	GPIOx->OTYPER &= ~(1<<Pin);  // bit 5=0 --> Output push pull
	GPIOx->OSPEEDR |= (1<<((Pin*2)+1));  // Pin PA5 (bits 11:10) as Fast Speed (1:0)
	GPIOx->PUPDR &= ~((1<<(Pin*2)) | (1<<((Pin*2)+1)));  // Pin PA5 (bits 11:10) are 0:0 --> no pull up or pulldown

}

void write (int dataf, GPIO_TypeDef  *GPIOx, uint32_t Pin)
{
	uint8_t i = 0;
	uint8_t Pin_cislo = 0;

	if (Pin == LL_GPIO_PIN_0)
		Pin_cislo = 0;
	else if (Pin == LL_GPIO_PIN_1)
		Pin_cislo = 1;
	else if (Pin == LL_GPIO_PIN_2)
		Pin_cislo = 2;
	else if (Pin == LL_GPIO_PIN_3)
		Pin_cislo = 3;
	else if (Pin == LL_GPIO_PIN_4)
		Pin_cislo = 4;
	else if (Pin == LL_GPIO_PIN_5)
		Pin_cislo = 5;
	else if (Pin == LL_GPIO_PIN_6)
		Pin_cislo = 6;
	else if (Pin == LL_GPIO_PIN_7)
		Pin_cislo = 7;
	else if (Pin == LL_GPIO_PIN_8)
		Pin_cislo = 8;
	else if (Pin == LL_GPIO_PIN_9)
		Pin_cislo = 9;
	else if (Pin == LL_GPIO_PIN_10)
		Pin_cislo = 10;
	else
		Pin_cislo = 15;

	//DS18B20_output(GPIOx, Pin);  // set as output
	for (i = 0; i < 8; i++)
	{
		if ((dataf & (1 << i)) != 0)  // LSB first
		{
			// write 1 sequence

			DS18B20_output(GPIOx, Pin_cislo);  // set as output
			LL_GPIO_ResetOutputPin(GPIOx, Pin); // Pull the Pin LOW
			delay1(2);  // wait for 1us
			//GPIOA->BSRR |= (1<<7); // Set the Pin PA7	HAL_GPIO_WritePin(GPIOx, Pin, GPIO_PIN_SET);

			DS18B20_input(GPIOx, Pin_cislo); // set the pin as input
			delay1(60);  // wait for 60us
		}
		else
		{
			// write 0
			DS18B20_output(GPIOx, Pin_cislo);
			LL_GPIO_ResetOutputPin(GPIOx, Pin);
			delay1(70);		// wait 60 - 120 us
			DS18B20_input(GPIOx, Pin_cislo);
		}
	}
}

int read (GPIO_TypeDef  *GPIOx, uint32_t Pin)
{
	int i = 0;
	int value = 0;
	uint8_t Pin_cislo = 0;

	if (Pin == LL_GPIO_PIN_0)
		Pin_cislo = 0;
	else if (Pin == LL_GPIO_PIN_1)
		Pin_cislo = 1;
	else if (Pin == LL_GPIO_PIN_2)
		Pin_cislo = 2;
	else if (Pin == LL_GPIO_PIN_3)
		Pin_cislo = 3;
	else if (Pin == LL_GPIO_PIN_4)
		Pin_cislo = 4;
	else if (Pin == LL_GPIO_PIN_5)
		Pin_cislo = 5;
	else if (Pin == LL_GPIO_PIN_6)
		Pin_cislo = 6;
	else if (Pin == LL_GPIO_PIN_7)
		Pin_cislo = 7;
	else if (Pin == LL_GPIO_PIN_8)
		Pin_cislo = 8;
	else if (Pin == LL_GPIO_PIN_9)
		Pin_cislo = 9;
	else if (Pin == LL_GPIO_PIN_10)
		Pin_cislo = 10;
	else
		Pin_cislo = 15;

	//DS18B20_input(GPIOx, Pin);
	for (i = 0; i < 8; i++)
	{
              // Initiate READ
		DS18B20_output(GPIOx, Pin_cislo);  // set as output
		LL_GPIO_ResetOutputPin(GPIOx, Pin);  // pull the pin LOW
		delay1(2);
		//DWT_Delay_us (2); // wait for 2 us

		//LL_GPIO_ResetOutputPin(GPIOA, LL_GPIO_PIN_15);
		DS18B20_input(GPIOx, Pin_cislo);  // set as input
		delay1(2);
		//LL_GPIO_SetOutputPin(GPIOA, LL_GPIO_PIN_15);
		if (LL_GPIO_IsInputPinSet(GPIOx, Pin))  // if the pin is high
		{
			value |= 1 << i;  // write 1
			//LL_GPIO_SetOutputPin(GPIOA, LL_GPIO_PIN_15);
		}
		delay1(60);
		//DWT_Delay_us (60);  // wait for 60 us

	}
	return value;
}
uint16_t preved_teplotu(uint8_t temp_l, uint8_t temp_h)
{
	uint16_t temp_lcr = 0;
	uint16_t temp = 0;

	if (temp_h > 7)
		  {
			  //temp_l = temp_l;
			  //temp_h = temp_h;

			  // Prevod z dvojkoveho doplnku
			  temp = ~((temp_h << 8)| temp_l);
			  temp += 1;

			  temp_lcr = ((temp & 0x000F) * 625) / 1000;

			  temp_l &= 0xF0;
			  temp_h &= 0x07;

			  temp = temp >> 4;
			  temp = (temp * 10) + temp_lcr; // pridani prvni platne cislice za desetinnou carkou
			  temp = temp + 2000;	// zaporne cislo -> offset 2000
			  return temp;
			 // printf("Teplota:  -%d,%d C\r\n", (int)temp, (int)temp_lcr);
		  }
		  else
		  {
			  temp_lcr = ((temp_l & 0x0F) * 625) / 1000;

			  temp_l &= 0xF0;
			  temp_h &= 0x07;

			  temp = (temp_h << 4) | (temp_l >> 4);
			  temp = (temp * 10) + temp_lcr; // pridani prvni platne cislice za desetinnou carkou
			  return temp;
			 // printf("Teplota:  %d,%d C\r\n", (int)temp, (int)temp_lcr);
		  }
}

int zjisti_teplotu (GPIO_TypeDef  *GPIOx, uint32_t Pin)
{

	int temp_l = 0;
	int temp_h = 0;
	int teplota = 0;
	 //check = reset ();
		  //DS18B20_init(GPIOx, Pin);1
		  if(DS18B20_init(GPIOx, Pin) != 0)
		  {
			  write (0xCC, GPIOx, Pin);  // skip ROM
			  write (0x44, GPIOx, Pin);  // convert t

			  delay1(800);
			  //HAL_Delay (800);
			  DS18B20_init(GPIOx, Pin);
			  //reset ();
			  /*  if(DS18B20_init() == 0)
		  	  {
		  		LCD_pozice(2, 10);
				LCD_cislo(2);
		 		}
		  	  else
		  	  {
		  		LCD_pozice(2, 10);
				LCD_cislo(1);
		  	  }*/
			  write (0xCC, GPIOx, Pin);  // skip ROM
			  write (0xBE, GPIOx, Pin);  // Read Scratchpad

			  temp_l = read(GPIOx, Pin);
			  temp_h = read(GPIOx, Pin);

			  teplota = preved_teplotu(temp_l, temp_h);

			  return teplota;
		  }
		  else
		  {
			  return 0x9999;
		  }
}
