//Knihovna pro I2C pro procesor STM32F070
//----------------------------------------------------------------------

#include "I2C_funkce.h"

void I2C_Master_Transmit(uint8_t address, uint8_t delka_dat, uint8_t *datove_pole)
{

	uint8_t i = 0;
	uint16_t counter_2 = 0;
	uint16_t I2C_delka_dat = 0;
	uint16_t I2C_pocitadlo_kol = 0;

	//------------------------------------------------
	I2C1->CR1 &= ~I2C_CR1_PE; 	// Peripheral disable

	I2C1->CR1 = 0;
	I2C1->CR2 = 0;

	I2C1->CR1 |= I2C_CR1_PE; 	// Peripheral enable
	//------------------------------------------------

	counter_2 = I2C_Max_Delay_Cycles;
	i = 0;
	while ((i != 1) && (counter_2 != 0))	// je-li BUSY, pockej chvili
	{
		if ((I2C1->ISR & I2C_ISR_BUSY) != I2C_ISR_BUSY)
		{
			i = 1;
		}
		counter_2--;
	}

	/* Prepare transfer parameters */
	I2C_delka_dat = delka_dat;//(pom_pole_counter / 2);		// hi2c->XferCount = Size;		// DOPLNIT!!!
	//    hi2c->XferISR   = NULL;

	/* Send Slave Address */
    /* Set NBYTES to write and reload if hi2c->XferCount > MAX_NBYTE_SIZE and generate RESTART */

	I2C1->CR2 &= ~I2C_CR2_RD_WRN;		// Master requests a write transfer.

	I2C1->CR2 &= ~I2C_CR2_ADD10;	// The master operates in 7-bit addressing mode
	I2C1->CR2 &= 0xFFFFFF00;
	I2C1->CR2 += (address << 0);		// adresa

	I2C1->CR2 &= 0xFF00FFFF;
	I2C1->CR2 += (I2C_delka_dat << 16);		// NBYTES

	I2C1->CR2 |= I2C_CR2_AUTOEND;	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred

	I2C1->CR2 |= I2C_CR2_START;		// Restart/Start generation


	counter_2 = I2C_Max_Delay_Cycles;

	//datove_pole++;			// vynecha se adresa na prvnim miste
	I2C_pocitadlo_kol = 0;	// vynecha se adresa na prvnim miste
	while ((I2C_pocitadlo_kol < I2C_delka_dat) && (counter_2 != 0))
	{
		/* Wait until TXIS flag is set */
		counter_2 = I2C_Max_Delay_Cycles;
		i = 0;
		while ((i != 1) && (counter_2 != 0))
		{
			if (I2C1->ISR & I2C_ISR_TXIS)
			{
				i = 1;
			}
			counter_2--;
		}

		/* Write data to TXDR */
		I2C1->TXDR = *datove_pole; //pom_pole_2[I2C_pocitadlo_kol];	 // hi2c->Instance->TXDR = *hi2c->pBuffPtr;

		/* Increment Buffer pointer */
		I2C_pocitadlo_kol++;
		datove_pole++;

	}

	/* No need to Check TC flag, with AUTOEND mode the stop is automatically generated */
	/* Wait until STOPF flag is set */
	counter_2 = I2C_Max_Delay_Cycles;
	i = 0;
	while ((i != 1) && (counter_2 != 0))
	{
		if (I2C1->ISR & I2C_ISR_STOPF)
		{
			i = 1;
		}
		counter_2--;
	}

	/* Clear STOP Flag */
	I2C1->ICR &= ~I2C_ICR_STOPCF;	// __HAL_I2C_CLEAR_FLAG(hi2c, I2C_FLAG_STOPF);

	/* Clear Configuration Register 2 */
	I2C1->CR2 = 0;	// I2C_RESET_CR2(hi2c);

}
//-------------------------------------------------------------------------------------
uint8_t I2C_Master_Receive(uint8_t address, uint8_t delka_dat, uint8_t *datove_pole)
{
	uint8_t i = 0;
	uint16_t counter_2 = 0;
	uint16_t I2C_delka_dat = 0;
	uint16_t I2C_pocitadlo_kol = 0;
	uint8_t chyba_prijmu = 0;

	counter_2 = I2C_Max_Delay_Cycles;
	i = 0;
	while ((i != 1) && (counter_2 != 0))	// je-li BUSY, pockej chvili
	{
		if ((I2C1->ISR & I2C_ISR_BUSY) != I2C_ISR_BUSY)
		{
			i = 1;
		}
		counter_2--;
	}

	if (counter_2 == 0)
		chyba_prijmu = 1;
    /*if (I2C_WaitOnFlagUntilTimeout(hi2c, I2C_FLAG_BUSY, SET, I2C_TIMEOUT_BUSY, tickstart) != HAL_OK)
    {
      return HAL_ERROR;
    }*/

    /*hi2c->State     = HAL_I2C_STATE_BUSY_RX;
    hi2c->Mode      = HAL_I2C_MODE_MASTER;
    hi2c->ErrorCode = HAL_I2C_ERROR_NONE;*/

    /* Prepare transfer parameters */
	I2C_delka_dat = delka_dat;
    /*hi2c->pBuffPtr  = pData;
    hi2c->XferCount = Size;
    hi2c->XferISR   = NULL;*/

    /* Send Slave Address */
    /* Set NBYTES to write and reload if hi2c->XferCount > MAX_NBYTE_SIZE and generate RESTART */
    /*if (hi2c->XferCount > MAX_NBYTE_SIZE)
    {
      hi2c->XferSize = MAX_NBYTE_SIZE;
      I2C_TransferConfig(hi2c, DevAddress, (uint8_t)hi2c->XferSize, I2C_RELOAD_MODE,
                         I2C_GENERATE_START_READ);
    }
    else
    {*/

	I2C1->CR2 |= I2C_CR2_RD_WRN;		// Master requests a read transfer.

	I2C1->CR2 &= ~I2C_CR2_ADD10;		// The master operates in 7-bit addressing mode
	I2C1->CR2 &= 0xFFFFFF00;
	I2C1->CR2 += (address << 0);		// adresa

	I2C1->CR2 &= 0xFF00FFFF;
	I2C1->CR2 += (I2C_delka_dat << 16);	// NBYTES

	I2C1->CR2 |= I2C_CR2_AUTOEND;		// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred

	I2C1->CR2 |= I2C_CR2_START;			// Restart/Start generation

      /*I2C_TransferConfig(hi2c, DevAddress, (uint8_t)hi2c->XferSize, I2C_AUTOEND_MODE,
                         I2C_GENERATE_START_READ);*/
   //}
	counter_2 = I2C_Max_Delay_Cycles;

	//datove_pole++;			// vynecha se adresa na prvnim miste
	I2C_pocitadlo_kol = 0;	// vynecha se adresa na prvnim miste
	while ((I2C_pocitadlo_kol < I2C_delka_dat) && (counter_2 != 0))
	{
		/* Wait until TXIS flag is set */
		counter_2 = I2C_Max_Delay_Cycles;
		i = 0;
		while ((i != 1) && (counter_2 != 0))
		{
			if (I2C1->ISR & I2C_ISR_RXNE)
			{
				i = 1;
			}
			counter_2--;
		}

		/* Write data to RXDR */
		*datove_pole = I2C1->RXDR; //pom_pole_2[I2C_pocitadlo_kol];	 // hi2c->Instance->TXDR = *hi2c->pBuffPtr;

		/* Increment Buffer pointer */
		I2C_pocitadlo_kol++;
		datove_pole++;

	}

	if (counter_2 == 0)
		chyba_prijmu = 1;

    /*while (hi2c->XferCount > 0U)
    {
      /* Wait until RXNE flag is set */
      /*if (I2C_WaitOnRXNEFlagUntilTimeout(hi2c, Timeout, tickstart) != HAL_OK)
      {
        return HAL_ERROR;
      }*/

      /* Read data from RXDR */
      /**hi2c->pBuffPtr = (uint8_t)hi2c->Instance->RXDR;

      /* Increment Buffer pointer */
     /* hi2c->pBuffPtr++;

      hi2c->XferSize--;
      hi2c->XferCount--;

      if ((hi2c->XferCount != 0U) && (hi2c->XferSize == 0U))
      {
        /* Wait until TCR flag is set */
      /*  if (I2C_WaitOnFlagUntilTimeout(hi2c, I2C_FLAG_TCR, RESET, Timeout, tickstart) != HAL_OK)
        {
          return HAL_ERROR;
        }

        /*if (hi2c->XferCount > MAX_NBYTE_SIZE)
        {
          hi2c->XferSize = MAX_NBYTE_SIZE;
          I2C_TransferConfig(hi2c, DevAddress, (uint8_t)hi2c->XferSize, I2C_RELOAD_MODE,
                             I2C_NO_STARTSTOP);
        }*/
      /*  else
        {
          hi2c->XferSize = hi2c->XferCount;
          I2C_TransferConfig(hi2c, DevAddress, (uint8_t)hi2c->XferSize, I2C_AUTOEND_MODE,
                             I2C_NO_STARTSTOP);
        }
      }
    }*/

    /* No need to Check TC flag, with AUTOEND mode the stop is automatically generated */
    /* Wait until STOPF flag is set */
	counter_2 = I2C_Max_Delay_Cycles;
	i = 0;
	while ((i != 1) && (counter_2 != 0))
	{
		if (I2C1->ISR & I2C_ISR_STOPF)
		{
			i = 1;
		}
		counter_2--;
	}
    /*if (I2C_WaitOnSTOPFlagUntilTimeout(hi2c, Timeout, tickstart) != HAL_OK)
    {
      return HAL_ERROR;
    }*/

    /* Clear STOP Flag */
	I2C1->ICR &= ~I2C_ICR_STOPCF;	// __HAL_I2C_CLEAR_FLAG(hi2c, I2C_FLAG_STOPF);
    //__HAL_I2C_CLEAR_FLAG(hi2c, I2C_FLAG_STOPF);

    /* Clear Configuration Register 2 */
	I2C1->CR2 = 0;	// I2C_RESET_CR2(hi2c);
    //I2C_RESET_CR2(hi2c);

    /*hi2c->State = HAL_I2C_STATE_READY;
    hi2c->Mode  = HAL_I2C_MODE_NONE;*/

	return chyba_prijmu;

}
