/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "I2C_funkce.h"
#include "ssd1306.h"	// pozn. Pro displej 1,3" nutno upravit hodnotu - SSD1306_WIDTH: 128 -> 130
#include "fonts.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
typedef struct
{
  uint16_t 	Napeti_3V3_filt[5];
  uint16_t 	Napeti_3V3_filt_seraz[5];
  uint16_t	Napeti_3V3;

  uint16_t 	Napeti_5V_filt[5];
  uint16_t 	Napeti_5V_filt_seraz[5];
  uint16_t	Napeti_5V;

  uint16_t 	Napeti_12V_filt[5];
  uint16_t 	Napeti_12V_filt_seraz[5];
  uint16_t	Napeti_12V;

  uint16_t 	Napeti_5V_pom_filt[5];
  uint16_t 	Napeti_5V_pom_filt_seraz[5];
  uint16_t	Napeti_5V_pom;

  uint8_t	Mereni_cnt;
}
Mereni_t;

Mereni_t Testovany_zdroj_napeti_t;

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define 	ADC_3V3 			ADC1, LL_ADC_CHANNEL_0    	// ADC vstupy
#define 	ADC_5V	 			ADC1, LL_ADC_CHANNEL_1
#define 	ADC_12V				ADC1, LL_ADC_CHANNEL_3
#define 	ADC_5V_POM 			ADC1, LL_ADC_CHANNEL_2

#define 	VERZE_SW			100		// Verze SW, 101 -> 1.1		// mozno az do verze x.50

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_ADC_Init(void);
static void MX_I2C1_Init(void);
static void MX_TIM3_Init(void);
/* USER CODE BEGIN PFP */
static void MX_TIM16_Init(void);

static void MX_IWDG_Init(void);
static void IWDG_ReloadCounter(void);

void TIM16_ZAP(void);
void TIM16_VYP(void);

void TIM3_ZAP(void);
void TIM3_VYP(void);

void Zobraz_hl_obrazovku(void);
void Zobraz_velicinu(void);

void Set_ADC_3V3(void);
void Set_ADC_5V(void);
void Set_ADC_12V(void);
void Set_ADC_5V_POM(void);

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

uint32_t mC = 0;
char smC[5];
uint16_t blik_T16 = 0;
uint8_t ADC_pom = 0;

uint32_t U_3V3 = 0;
uint32_t U_5V = 0;
uint32_t U_12V = 0;
uint32_t U_5V_POM = 0;

void Set_ADC_3V3(void)
{
	LL_ADC_REG_SetSequencerChRem(ADC_5V);
	LL_ADC_REG_SetSequencerChRem(ADC_12V);
	LL_ADC_REG_SetSequencerChRem(ADC_5V_POM);

	LL_ADC_REG_SetSequencerChAdd(ADC_3V3);
	ADC_pom = 0;
	ADC1->CR |= ADC_CR_ADSTART; // spusteni prevodu
}
void Set_ADC_5V(void)
{
	LL_ADC_REG_SetSequencerChRem(ADC_3V3);
	LL_ADC_REG_SetSequencerChRem(ADC_12V);
	LL_ADC_REG_SetSequencerChRem(ADC_5V_POM);

	LL_ADC_REG_SetSequencerChAdd(ADC_5V);
	ADC_pom = 1;
	ADC1->CR |= ADC_CR_ADSTART; // spusteni prevodu
}
void Set_ADC_12V(void)
{
	LL_ADC_REG_SetSequencerChRem(ADC_3V3);
	LL_ADC_REG_SetSequencerChRem(ADC_5V);
	LL_ADC_REG_SetSequencerChRem(ADC_5V_POM);

	LL_ADC_REG_SetSequencerChAdd(ADC_12V);
	ADC_pom = 2;
	ADC1->CR |= ADC_CR_ADSTART; // spusteni prevodu
}
void Set_ADC_5V_POM(void)
{
	LL_ADC_REG_SetSequencerChRem(ADC_3V3);
	LL_ADC_REG_SetSequencerChRem(ADC_5V);
	LL_ADC_REG_SetSequencerChRem(ADC_12V);

	LL_ADC_REG_SetSequencerChAdd(ADC_5V_POM);
	ADC_pom = 3;
	ADC1->CR |= ADC_CR_ADSTART; // spusteni prevodu
}
//-------------------------------------------------------------------
void TIM16_ZAP(void)
{
    TIM16->CNT = 0;
    TIM16->SR &= ~TIM_SR_UIF;
    TIM16->DIER |= TIM_DIER_UIE;  // povol interrupt od TIM16
    TIM16->CR1 |= TIM_CR1_CEN;    // spust TIM16
}

void TIM16_VYP(void)
{
	TIM16->DIER &= ~TIM_DIER_UIE;  // zakaz interrupt od TIM16
	TIM16->CR1 &= ~TIM_CR1_CEN;    // zastav TIM16
}
//-------------------------------------------------------------------
void TIM3_ZAP(void)
{
    TIM3->CNT = 0;
    TIM3->SR &= ~TIM_SR_UIF;
    TIM3->DIER |= TIM_DIER_UIE;  // povol interrupt od TIM3
    TIM3->CR1 |= TIM_CR1_CEN;    // spust TIM3
}

void TIM3_VYP(void)
{
	TIM3->DIER &= ~TIM_DIER_UIE;  // zakaz interrupt od TIM3
	TIM3->CR1 &= ~TIM_CR1_CEN;    // zastav TIM3
}
//-------------------------------------------------------------------
void TIM16_IRQHandler(void)	// TIM16 - obecny pomocny casovac 100 ms
{
	if(TIM16->SR & TIM_SR_UIF) // if UIF flag is set
	{
		TIM16->SR &= ~TIM_SR_UIF; // clear UIF flag

		blik_T16++;
	}
}
//------------------------------------------------------------------------
void TIM3_IRQHandler(void)
{
	if(TIM3->SR & TIM_SR_UIF) // if UIF flag is set
	{
		TIM3->SR &= ~TIM_SR_UIF; // clear UIF flag
	}


	Set_ADC_3V3();	// Zacni prevod napetim 3V3

	while(ADC_pom != 3);	// pockej nez budou prevedena vsechna napeti
	IWDG_ReloadCounter();

	Zobraz_hl_obrazovku();	// Zmerena napeti zobraz
}
//-------------------------------------------------------------------

void ADC1_IRQHandler(void)
{
	if(ADC1->ISR & ADC_ISR_EOSEQ) // if EOSEQ flag is set
	{
		ADC1->ISR = ADC_ISR_EOSEQ; // clear EOSEQ flag
		ADC1->CR |= ADC_CR_ADSTP; // vypnuti prevodu
	}

    if(ADC_pom == 0)		// 3V3
	{
    	U_3V3 = (ADC1->DR) * 16; 	// 4096 -> cca 6,6 V, 1 jednotka ADC -> cca 1,6 mV
    	U_3V3 = U_3V3 / 10;			// vysledek v mV

    	//U_3V3 = 3280;

    	Set_ADC_5V();
	}//---------------------------------------------------------
	else if(ADC_pom == 1)	// 5V
	{
		U_5V = (ADC1->DR) * 16;		// 4096 -> cca 6,6 V, 1 jednotka ADC -> cca 1,6 mV
		U_5V = U_5V / 10;			// vysledek v mV

		//U_5V = 4960;

		Set_ADC_12V();
	}//---------------------------------------------------------
	else if(ADC_pom == 2)	// 12V
	{
		U_12V = (ADC1->DR) * 46;	// 4096 -> cca 18,8 V, 1 jednotka ADC -> cca 4,6 mV
		U_12V = U_12V / 10;			// vysledek v mV

		//U_12V = 11960;

		Set_ADC_5V_POM();
	}//---------------------------------------------------------
	else					// 5V_pom
	{
		U_5V_POM = (ADC1->DR) * 16;	// 4096 -> cca 6,6 V, 1 jednotka ADC -> cca 1,6 mV
		U_5V_POM = U_5V_POM / 10;

		//U_5V_POM = 5120;
	}

	//ADC1->CR |= ADC_CR_ADSTART; // spusteni prevodu
}
//-------------------------------------------------------------------
void Zobraz_hl_obrazovku(void)
{
	Zobraz_velicinu();
	SSD1306_UpdateScreen();
}
//-------------------------------------------------------------------
void Zobraz_velicinu(void)
{
	//----------------------------------
	// Napeti 3V3
	mC = U_3V3 / 1000;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_GotoXY (0, 8);
	SSD1306_Puts (smC, &Font_16x26, 1);

	mC = U_3V3 % 1000;
	mC = mC / 100;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts ("v", &Font_16x26, 1);
	SSD1306_Puts (smC, &Font_16x26, 1);

	//----------------------------------
	// Napeti +5V
	mC = U_5V / 1000;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_GotoXY (0, 36);
	SSD1306_Puts (smC, &Font_16x26, 1);

	mC = U_5V % 1000;
	mC = mC / 100;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts ("v", &Font_16x26, 1);
	SSD1306_Puts (smC, &Font_16x26, 1);

	//----------------------------------
	// Napeti +12V
	mC = U_12V / 1000;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_GotoXY (64, 8);
	SSD1306_Puts (smC, &Font_16x26, 1);

	mC = U_12V % 1000;
	mC = mC / 100;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts ("v", &Font_16x26, 1);
	SSD1306_Puts (smC, &Font_16x26, 1);
	SSD1306_Puts (" ", &Font_16x26, 1);

	//----------------------------------
	// Napeti +5V pom
	mC = U_5V_POM / 1000;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_GotoXY (64, 36);
	SSD1306_Puts ("+", &Font_16x26, 1);
	SSD1306_Puts (smC, &Font_16x26, 1);

	mC = U_5V_POM % 1000;
	mC = mC / 100;
	itoa(mC, smC, 10); // Convert integer to string

	SSD1306_Puts ("v", &Font_16x26, 1);
	SSD1306_Puts (smC, &Font_16x26, 1);
}
//-------------------------------------------------------------------



/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */

  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_SYSCFG);
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWR);

  /* System interrupt init*/
  /* SysTick_IRQn interrupt configuration */
  NVIC_SetPriority(SysTick_IRQn, 3);

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_ADC_Init();
  MX_I2C1_Init();
  MX_TIM3_Init();
  /* USER CODE BEGIN 2 */
  MX_TIM16_Init();
  SSD1306_Init(); // initialize the display

  //------------
  SSD1306_GotoXY (5, 8);
  SSD1306_Puts("Meric U", &Font_16x26, 1);// na font 16x26 max. 8 pismen
  SSD1306_GotoXY (5, 36);
  SSD1306_Puts ("v ", &Font_16x26, 1);

  mC = VERZE_SW / 100;
  itoa(mC, smC, 10); // Convert integer to string

  SSD1306_Puts (smC, &Font_16x26, 1);
  SSD1306_Puts (".", &Font_16x26, 1);

  mC = VERZE_SW % 50;
  itoa(mC, smC, 10); // Convert integer to string
  SSD1306_Puts (smC, &Font_16x26, 1);
  SSD1306_UpdateScreen(); // update screen

  blik_T16 = 0;
  TIM16_ZAP();
  while(blik_T16 < 30)	// 3 s - Start programu, aby byla videt uvodni obrazovka
  {
	  ;//LL_IWDG_ReloadCounter(IWDG);	//  Watchdog
  }
  TIM16_VYP();

  SSD1306_Fill(SSD1306_COLOR_BLACK);
  SSD1306_UpdateScreen(); // update screen


  TIM3_ZAP();

  // Watchdog
  MX_IWDG_Init();

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  LL_FLASH_SetLatency(LL_FLASH_LATENCY_0);
  while(LL_FLASH_GetLatency() != LL_FLASH_LATENCY_0)
  {
  }
  LL_RCC_HSI_Enable();

   /* Wait till HSI is ready */
  while(LL_RCC_HSI_IsReady() != 1)
  {

  }
  LL_RCC_HSI_SetCalibTrimming(16);
  LL_RCC_HSI14_Enable();

   /* Wait till HSI14 is ready */
  while(LL_RCC_HSI14_IsReady() != 1)
  {

  }
  LL_RCC_HSI14_SetCalibTrimming(16);
  LL_RCC_SetAHBPrescaler(LL_RCC_SYSCLK_DIV_1);
  LL_RCC_SetAPB1Prescaler(LL_RCC_APB1_DIV_1);
  LL_RCC_SetSysClkSource(LL_RCC_SYS_CLKSOURCE_HSI);

   /* Wait till System clock is ready */
  while(LL_RCC_GetSysClkSource() != LL_RCC_SYS_CLKSOURCE_STATUS_HSI)
  {

  }
  LL_Init1msTick(8000000);
  LL_SetSystemCoreClock(8000000);
  LL_RCC_HSI14_EnableADCControl();
  LL_RCC_SetI2CClockSource(LL_RCC_I2C1_CLKSOURCE_HSI);
}

/**
  * @brief ADC Initialization Function
  * @param None
  * @retval None
  */
static void MX_ADC_Init(void)
{

  /* USER CODE BEGIN ADC_Init 0 */

  /* USER CODE END ADC_Init 0 */

  LL_ADC_InitTypeDef ADC_InitStruct = {0};
  LL_ADC_REG_InitTypeDef ADC_REG_InitStruct = {0};

  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_ADC1);

  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  /**ADC GPIO Configuration
  PA0   ------> ADC_IN0
  PA1   ------> ADC_IN1
  PA2   ------> ADC_IN2
  PA3   ------> ADC_IN3
  */
  GPIO_InitStruct.Pin = LL_GPIO_PIN_0;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_1;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_2;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_3;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* ADC interrupt Init */
  NVIC_SetPriority(ADC1_IRQn, 0);
  NVIC_EnableIRQ(ADC1_IRQn);

  /* USER CODE BEGIN ADC_Init 1 */

  /* USER CODE END ADC_Init 1 */
  /** Configure Regular Channel
  */
  LL_ADC_REG_SetSequencerChAdd(ADC1, LL_ADC_CHANNEL_0);
  /** Configure Regular Channel
  */
  LL_ADC_REG_SetSequencerChAdd(ADC1, LL_ADC_CHANNEL_1);
  /** Configure Regular Channel
  */
  LL_ADC_REG_SetSequencerChAdd(ADC1, LL_ADC_CHANNEL_2);
  /** Configure Regular Channel
  */
  LL_ADC_REG_SetSequencerChAdd(ADC1, LL_ADC_CHANNEL_3);
  /** Configure the global features of the ADC (Clock, Resolution, Data Alignment and number of conversion)
  */
  ADC_InitStruct.Clock = LL_ADC_CLOCK_ASYNC;
  ADC_InitStruct.Resolution = LL_ADC_RESOLUTION_12B;
  ADC_InitStruct.DataAlignment = LL_ADC_DATA_ALIGN_RIGHT;
  ADC_InitStruct.LowPowerMode = LL_ADC_LP_MODE_NONE;
  LL_ADC_Init(ADC1, &ADC_InitStruct);
  ADC_REG_InitStruct.TriggerSource = LL_ADC_REG_TRIG_SOFTWARE;
  ADC_REG_InitStruct.SequencerDiscont = LL_ADC_REG_SEQ_DISCONT_DISABLE;
  ADC_REG_InitStruct.ContinuousMode = LL_ADC_REG_CONV_SINGLE;
  ADC_REG_InitStruct.DMATransfer = LL_ADC_REG_DMA_TRANSFER_NONE;
  ADC_REG_InitStruct.Overrun = LL_ADC_REG_OVR_DATA_PRESERVED;
  LL_ADC_REG_Init(ADC1, &ADC_REG_InitStruct);
  LL_ADC_REG_SetSequencerScanDirection(ADC1, LL_ADC_REG_SEQ_SCAN_DIR_FORWARD);
  LL_ADC_SetSamplingTimeCommonChannels(ADC1, LL_ADC_SAMPLINGTIME_71CYCLES_5);
  /* USER CODE BEGIN ADC_Init 2 */

  ADC1->IER |= ADC_IER_EOSEQIE; // End of Sequence of conversion interrupt enable
  ADC1->CR |= ADC_CR_ADEN; // povoleni ADC

  /* USER CODE END ADC_Init 2 */

}

/**
  * @brief I2C1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C1_Init(void)
{

  /* USER CODE BEGIN I2C1_Init 0 */

  /* USER CODE END I2C1_Init 0 */

  LL_I2C_InitTypeDef I2C_InitStruct = {0};

  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  /**I2C1 GPIO Configuration
  PA9   ------> I2C1_SCL
  PA10   ------> I2C1_SDA
  */
  GPIO_InitStruct.Pin = LL_GPIO_PIN_9;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_HIGH;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_OPENDRAIN;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_4;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_10;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_HIGH;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_OPENDRAIN;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_4;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* Peripheral clock enable */
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_I2C1);

  /* USER CODE BEGIN I2C1_Init 1 */

  /* USER CODE END I2C1_Init 1 */
  /** I2C Initialization
  */
  LL_I2C_DisableOwnAddress2(I2C1);
  LL_I2C_DisableGeneralCall(I2C1);
  LL_I2C_EnableClockStretching(I2C1);
  I2C_InitStruct.PeripheralMode = LL_I2C_MODE_I2C;
  I2C_InitStruct.Timing = 0x2000090E;
  I2C_InitStruct.AnalogFilter = LL_I2C_ANALOGFILTER_ENABLE;
  I2C_InitStruct.DigitalFilter = 0;
  I2C_InitStruct.OwnAddress1 = 0;
  I2C_InitStruct.TypeAcknowledge = LL_I2C_ACK;
  I2C_InitStruct.OwnAddrSize = LL_I2C_OWNADDRESS1_7BIT;
  LL_I2C_Init(I2C1, &I2C_InitStruct);
  LL_I2C_EnableAutoEndMode(I2C1);
  LL_I2C_SetOwnAddress2(I2C1, 0, LL_I2C_OWNADDRESS2_NOMASK);
  /* USER CODE BEGIN I2C1_Init 2 */

  /* USER CODE END I2C1_Init 2 */

}

/**
  * @brief TIM3 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM3_Init(void)	// po 100 ms casovani ADC
{

	if (!(RCC->APB1ENR & RCC_APB1ENR_TIM3EN))
	{
		RCC->APB1ENR |= RCC_APB1ENR_TIM3EN;
		RCC->APB1RSTR |= RCC_APB1RSTR_TIM3RST;
		RCC->APB1RSTR &= ~RCC_APB1RSTR_TIM3RST;
	}

  TIM3->PSC = (SystemCoreClock / 1000) - 1; // 1 kHz -> 1 ms
  TIM3->CR1 |= TIM_CR1_DIR; // LL_TIM_COUNTERMODE_UP
  TIM3->CR2 = 0;
  TIM3->ARR = 500 - 1; // po 500 ms
  // ClockDivision_1

  TIM3->CR1 |= TIM_CR1_ARPE; // LL_TIM_EnableARRPreload(TIM3);
  // LL_TIM_SetClockSource(TIM3, LL_TIM_CLOCKSOURCE_INTERNAL);
  // LL_TIM_SetTriggerOutput(TIM3, LL_TIM_TRGO_RESET);
  TIM3->SMCR &= ~TIM_SMCR_MSM; // LL_TIM_DisableMasterSlaveMode(TIM3);


  /* TIM3 interrupt Init */
  NVIC_SetPriority(TIM3_IRQn, 1); // 1
  NVIC_EnableIRQ(TIM3_IRQn);
  /* USER CODE BEGIN TIM1_Init 2 */

  /* USER CODE END TIM1_Init 2 */

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOF);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOB);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_0;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOF, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_1;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOF, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_4;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_5;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_6;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_7;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LL_GPIO_PIN_1;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(GPIOB, &GPIO_InitStruct);

}

/* USER CODE BEGIN 4 */

static void MX_TIM16_Init(void)	// Po 100 ms - obecny pomocny casovac
{

  /* USER CODE BEGIN TIM16_Init 0 */

  /* USER CODE END TIM16_Init 0 */

  LL_TIM_InitTypeDef TIM_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_TIM16);

  /* TIM16 interrupt Init */
  NVIC_SetPriority(TIM16_IRQn, 1);
  NVIC_EnableIRQ(TIM16_IRQn);

  /* USER CODE BEGIN TIM16_Init 1 */

  /* USER CODE END TIM16_Init 1 */
  TIM_InitStruct.Prescaler = SystemCoreClock / 1000 - 1; // 1ms = 1kHz
  TIM_InitStruct.CounterMode = LL_TIM_COUNTERMODE_UP;
  TIM_InitStruct.Autoreload = 100 - 1;	// 100 ms
  TIM_InitStruct.ClockDivision = LL_TIM_CLOCKDIVISION_DIV1;
  TIM_InitStruct.RepetitionCounter = 0;
  LL_TIM_Init(TIM16, &TIM_InitStruct);
  LL_TIM_DisableARRPreload(TIM16);
  /* USER CODE BEGIN TIM16_Init 2 */

  /* USER CODE END TIM16_Init 2 */

}

static void MX_IWDG_Init(void)
{

  /* USER CODE BEGIN IWDG_Init 0 */

  /* USER CODE END IWDG_Init 0 */

  /* USER CODE BEGIN IWDG_Init 1 */

  /* USER CODE END IWDG_Init 1 */
    // 1) Zapnout LSI
    RCC->CSR |= RCC_CSR_LSION;                    // Zapnout LSI
    while ((RCC->CSR & RCC_CSR_LSIRDY) == 0);    // Cekat na stabilizaci LSI

    // 2) Povolit prstup k IWDG registrum (Write Access)
    IWDG->KR = 0x5555;

    // 3) Nastavit prescaler na 256
    IWDG->PR = 0x06;  // 0x06 = prescaler 256

		// 4) Nastavit reload na 624 pro cca 4s timeout
		IWDG->RLR = 624 & 0x0FFF;

    // 5) Reloadovat counter (nakrmit watchdog)
    IWDG->KR = 0xAAAA;

    // 6) Spustit watchdog
    IWDG->KR = 0xCCCC;
  /* USER CODE BEGIN IWDG_Init 2 */

  /* USER CODE END IWDG_Init 2 */

}

static void IWDG_ReloadCounter(void)
{
    // Prekrm watchdog (reload counter)
    IWDG->KR = 0xAAAA;
}

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
